VERSION 8; ; 8300
* -----------------------------------------------------------------------------
* @filedoc
* @file Topo_LinieAusPunkten.CSX
* @brief Bsp. fr Linienerzeugung ber Punkte 
* 
* Beispiel: Topografielinie aus vorh. Punkten generieren, Nebenattribute setzen
* Hinweis: Die Punkte mssen zuvor mit dem Skript Topo_PunkteAusKoordinaten.CSX generiert werden!  
*
* -----------------------------------------------------------------------------
* Copyright (C) IB&T
* 
* Gewhrleistung und Nutzung
* 
* Die Nutzung des Skriptes erfolgt stets auf eigene Gefahr. IB&T bernimmt keine
* Gewhr dafr, dass die Nutzung dieses Skriptes zu Ihrem gewnschten Ergebnis
* fhrt. Da CardScripte vorhandene Projektdaten durch Direktzugriff auf die
* jeweiligen Datenbanken auch ohne weitere Sicherheitsabfragen unbemerkt verndern
* oder lschen knnen, erfordert eine Nutzung entsprechende Kenntnisse und groe
* Sorgfalt. IB&T haftet nicht fr eventuell entstehende Datenverluste und
* Folgeschden, die durch die Nutzung von CardScripten entstehen.
*
* -----------------------------------------------------------------------------
* @author JH
* @endfiledoc
* -----------------------------------------------------------------------------
*       1 14.05.09 JH Version fr die 8.3 hergestellt
* @history
* -----------------------------------------------------------------------------

* Vereinbarungen -------------------------------------------------------------------------------

BILDSCHIRM GRAFIK                  | gibt die Meldungen im Arbeitsprotokoll aus

* Zuweisungen ----------------------------------------------------------------------------------

!Schicht = "Testlinien"            | Name der Schicht

* Deklarationen --------------------------------------------------------------------------------

SYMBOLE /TOPOSYS/ Toposys          | Symbol fr das System der Topografierdaten
SYMBOLE /POINTSYS/ PointSys        | Symbol fr das System der Punkte

SYMBOLE /TOPOLAYER/ Schicht        | Symbol fr die Schicht
SYMBOLE /TOPOLINE/ Linie           | Symbol fr die Topografielinie
SYMBOLE /POINT/ Punkt              | Symbol fr den Punkt

* Ausfhrungen ---------------------------------------------------------------------------------

* Systemobjekte
PointSys = Project.GetPointSys()                 | liefert das Objekt fr das System der Punkte
Toposys = Project.GetTopoSys()                   | liefert das Objekt fr das System der Topografiedaten

* Schichtobjekt
Schicht = Toposys.GetLayerByName(!Schicht)       | liefert die vorhandene Schicht
WENN Schicht == $NULL DANN                       | Wenn Schicht nicht vorhanden, wird eine neue Schicht angelegt  
  Schicht = Toposys.CreateLayer(!Schicht)
SONST                                            | Wenn Schicht vorhanden, werden die Topografielinien gelscht
  TEXTGEN !Meldung; "Schicht '#' ist bereits vorhanden --> Daten werden gelscht!"; !Schicht
  MELDUNG NEUTRAL; !Meldung
  Toposys.ClearLines(Schicht)                    | lscht alle Linien der Schicht
WEITER

* Linienobjekt
Linie = Toposys.CreateLine(Schicht; 33)          | erzeugt eine neue Linie in angelegter Schicht

* Linieninformationen + Nebenattribute
Linie.SetName("Testlinie1")                      | setzt den Namen der Linie
Linie.SetAttribute("01--Kategorie"; "Testlinie") | setzt die Nebenattribute
Linie.SetAttribute("02--Kode"; "33")

* Schleife zur Erzeugung einer Linie ber 40 Punkte der Punktdatenbank
SCHLEIFE I = 1; 40

  TEXTGEN !PunktNr; "Punkt00-#"; I               | generiert die Punktnummer (aus Schleifenzhler)

  * Punktobjekt
  Punkt = PointSys.GetPoint(!PunktNr)            | liefert den vorhandenen Punkt
  WENN Punkt <> $NULL DANN                       | Wenn Punkt vorhanden, wird dieser an das Ende der Linie eingefgt
    Linie.AddPoint(Punkt)
  SONST                                          | Wenn Punkt nicht vorhanden, wird die Linienerzeugung abgebrochen
    TEXTGEN !Meldung; "Punkt '#' ist nicht vorhanden --> Linienerzeugung wird abgebrochen!"; !PunktNr
    MELDUNG FEHLER; !Meldung
    ABBRUCH SCHLEIFE
  WEITER

ENDE SCHLEIFE